import alice.tucson.api.*;
import alice.logictuple.*;
import javax.swing.*;

/*Thread che si occupa di osservare se ci sono nuovi messaggi e visualizzarli
 *
 *@author Rossella Rubino
 *@version agosto1 2004 
 */

public class AgentObserverMsg extends Thread {

	private JTextArea output;
    private TucsonContext context;
    private TupleCentreId myTC;

        public AgentObserverMsg(JTextArea output, AgentId aid, TupleCentreId id) throws Exception {
            this.output=output;
            this.myTC=id;
            context = Tucson.enterContext(new DefaultContextDescription(aid));
        }

        public void run(){
            try {
                while (true) {
                    LogicTuple msg=context.in(myTC,LogicTuple.parse("msg(_,_,_,_)"));
	                TupleArgument who=msg.getArg(0).getArg(0);
                    TupleArgument content=msg.getArg(2).getArg(0);
                    TupleArgument when=msg.getArg(3).getArg(0);

                    output.append(toFlatString(who.toString())+">  "+toFlatString(content.toString())+"\n");
                    output.setCaretPosition(output.getText().length());
                }
            } catch (Exception ex){
                ex.printStackTrace();
            }
        }
		
		/*metodo usato per eliminare gli apici all'inizio e alla fine di una stringa
		 *
		 *@param st stringa su cui lavorare
		 *@return stringa senza apici
		 */
        private String toFlatString(String st){
            if (st.startsWith("'")&&st.endsWith("'")){
                return st.substring(1,st.length()-1);
            } else {
                return st;
            }
        }

    }